//=============================================================================
// MenuTransformerGun, for the ultimate in user friendly.
//=============================================================================
class BLMenuWeaponVendor expands MenuUIWindow;

var BLWeaponVendor Vendor;
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var TileWindow BuyList, SellList;
var BLVendorTile CurSelection;
var int CurTile;
var int MaxSell;

var PersonaHeaderTextWindow WalletText, TimerText, SlotsText, BuyText, SellText, TipText;

var PersonaHeaderTextWindow StatDisplay;


var int MinLeft, SecLeft;

#exec TEXTURE IMPORT NAME="VendorBG1" FILE="Textures\VendorBG1.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG2" FILE="Textures\VendorBG2.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG3" FILE="Textures\VendorBG3.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG4" FILE="Textures\VendorBG4.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG5" FILE="Textures\VendorBG5.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG6" FILE="Textures\VendorBG6.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG7" FILE="Textures\VendorBG7.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG8" FILE="Textures\VendorBG8.pcx" GROUP=UI FLAGS=2
#exec TEXTURE IMPORT NAME="VendorBG9" FILE="Textures\VendorBG9.pcx" GROUP=UI FLAGS=2

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------

function SetTimings(int Min, int Sec)
{
 MinLeft = Min;
 SecLeft = Sec;
 
 AddTimer(1.0, True,, 'SelfUpdateTimer');
}

function UpdateTileNum(int i)
{
 local BLVendorTile T;
 
 CurSelection.SetHighlight(False);
 
 CurTile = i;
 
 forEach AllObjects(class'BLVendorTile', T)
 {
  if (T.ListNum == CurTile)
  {
   CurSelection = T;
   CurSelection.SetHighlight(True);
  }
 }

 //EnableButtons();
}

function SelfUpdateTimer()
{
 local String TimeString;
 
 if (SecLeft > 0) SecLeft--;
 
 if (SecLeft <= 0)
 {
  if (MinLeft > 0)
  { 
   SecLeft = 59;
   MinLeft--;
  }
 }
 
 if (SecLeft > 9) TimeString = MinLeft$":"$SecLeft;
 if (SecLeft < 10) TimeString = MinLeft$":0"$SecLeft;
 
 UpdateTimer(TimeString);
}

function UpdateTimer(String S)
{
 WalletText.SetText("|p4Funds: $"$DeusExPlayer(GetPlayerPawn()).Credits);
 TimerText.SetText("|cffffff"$S);
 SlotsText.SetText(BuildSlotUsage());
}

function String BuildSlotUsage()
{
 local DeusExPlayer P;
 local string S;
 local int Total, C;
 local Inventory I;
 
 P = Vendor.P;
 
 forEach Vendor.AllActors(class'Inventory', I)
 {
  if (I.Owner == P && (I.IsA('DeusExWeapon') || I.IsA('DeusExPickup')) && !I.IsA('NanoKeyRing'))
  {
   C = I.InvSlotsX * I.InvSlotsY;
   if (C < 0) C = 0;
   Total += C;
   P.AddNote(""$I$C);
  }
 }
 
 S = "|p1"$Total$"/30";
 
 return S;
}

function String BuildWeaponStats()
{
 local string S;
 
 local string strInfo, nl, ElmStr;
 local string Dam, Rate, Acc, Clip, CompInfo, LevelInfo, Desc;

 local DeusExWeapon W;
 
 W = DeusExWeapon(CurSelection.Item);
 
 if (W == None) return "";
 	
			nl = CR();
			LevelInfo= "|caaaaaaLevel Requirement: "$W.GetPropertyText("WeaponLevel");
			Dam = "|cff8888Damage: "$W.GetPropertyText("hitDamage")$" |cffff88x"$W.GetPropertyText("NumProj");
			Rate = "|cff8855Fire Rate: "$FormatFloatString(1.0/ float(W.GetPropertyText("ShotTime")), 0.1)$" Rnds/Sec";			
			Acc = "|cbbff88Accuracy: "$int(  (2.0 - float(W.GetPropertyText("BaseAccuracy")) ) * 50.0   )$"%";
			Clip = "|c8888ffClip Size: "$int(W.GetPropertyText("ReloadCount"));
			if (W.GetPropertyText("CompanyName") != "") CompInfo = W.GetPropertyText("CompanyColor")$W.GetPropertyText("CompanyName");


			/*s = LevelInfo$nl;
			s = StrInfo$W.GetPropertyText("ItemName")$":"$nl$Dam$nl;
			s = StrInfo$Rate$nl$Acc$nl;
			s = StrInfo$Clip;*/


			if (W.GetPropertyText("ThreatType") != "None")
			{
			 ElmStr = nl$int(W.GetPropertyText("ThreatRange")) * 25$"% chance of "$W.GetPropertyText("ThreatType")$" Damage";
			 
			 if (W.GetPropertyText("ThreatType") ~= "Explosive") ElmStr = "|p4"$ElmStr;
			 if (W.GetPropertyText("ThreatType") ~= "Fire") ElmStr = "|cf88"$ElmStr;
			 if (W.GetPropertyText("ThreatType") ~= "Acid") ElmStr = "|p3"$ElmStr;
			 if (W.GetPropertyText("ThreatType") ~= "Shock") ElmStr = "|p7"$ElmStr;
			}
			//if (CompInfo ~= "") S = S$ElmStr;
			//if (CompInfo != "") S = S$ElmStr$nl$nl$CompInfo;
			if (W.GetPropertyText("CustomDescription") != "")
			{
			 Desc = nl$W.GetPropertyText("DescriptionColor")$Chr(34)$W.GetPropertyText("CustomDescription")$Chr(34);
			}

			if (Desc != "")
			{
			 CompInfo = CompInfo$Desc;
			}

			if (W.IsA('BorderlandsWeapon')) S = S$nl$"|p4Worth $"$BorderlandsWeapon(W).GetResaleValue();




 S = W.ItemName$nl$LevelInfo@Dam$nl$Rate@Acc$nl$Clip$ElmStr$nl$nl$CompInfo;
 
 return S;




}



simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function ResetList()
{
	if (BuyList != None) BuyList.Hide();
	if (SellList != None) SellList.Hide();
	
	CreateBuyList();
	CreateSellList();
	PopulateBuyList();
	PopulateSellList();
	
	//ForceShittyUpdate();
}

function CreateBuyList()
{
        BuyList = CreateScrollTileWindow(10, 41, 263, 300);
	BuyList.SetMinorSpacing(0);
	BuyList.SetMargins(0,0);
	BuyList.SetOrder(ORDER_Down);
        BuyList.SetSensitivity(TRUE);
}
function CreateSellList()
{
        SellList = CreateScrollTileWindow(352, 41, 263, 300);
	SellList.SetMinorSpacing(0);
	SellList.SetMargins(0,0);
	SellList.SetOrder(ORDER_Down);
        SellList.SetSensitivity(TRUE);
}

// ----------------------------------------------------------------------
// CreateScrollTileWindow()
// ----------------------------------------------------------------------

function TileWindow CreateScrollTileWindow(
	int posX, int posY,
	int sizeX, int sizeY)
{
	local TileWindow tileWindow;
	local PersonaScrollAreaWindow winScroll;

	winScroll = PersonaScrollAreaWindow(winClient.NewChild(Class'PersonaScrollAreaWindow'));
	winScroll.SetPos(posX, posY);
	winScroll.SetSize(sizeX, sizeY);

	tileWindow   = CreateTileWindow(winScroll.clipWindow);

	return tileWindow;
}

// ----------------------------------------------------------------------
// CreateTileWindow()
// ----------------------------------------------------------------------

function TileWindow CreateTileWindow(Window parent)
{
	local TileWindow tileWindow;

	// Create Tile Window inside the scroll window
	tileWindow = TileWindow(parent.NewChild(Class'TileWindow'));
	tileWindow.SetFont(Font'FontMenuSmall');
	tileWindow.SetOrder(ORDER_Down);
	tileWindow.SetChildAlignments(HALIGN_Full, VALIGN_Top);
	tileWindow.MakeWidthsEqual(False);
	tileWindow.MakeHeightsEqual(False);

	return tileWindow;
}


function PopulateBuyList()
{
	local BLVendorTile T;
	local int i;

	for(i=0; i<10; i++)
	{
	  T = BLVendorTile(BuyList.NewChild(Class'BLVendorTile'));
	  T.SetItem(Vendor.Stock[i]);
	  T.SetNum(i);
	}
	
	CurTile = 0;
}

function PopulateSellList()
{
	local BLVendorTile T;
	local BorderlandsWeapon W;
	local int i;

	MaxSell = 0;

	forEach Vendor.AllActors(class'BorderlandsWeapon', W)
	{
	 if (W.Owner == Vendor.P)
	 {
	  MaxSell++;

	  T = BLVendorTile(SellList.NewChild(Class'BLVendorTile'));
	  T.SetItem(W);
	  T.SetNum(i);

	  i++;
	 }
	}
	
	CurTile = 0;
}




function UpdateInfo()
{
}

function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 local bool bBuy, bReturn;
 local int Price;
 local DeusExPlayer P;
 local int slotsRow, slotsCol;
 
 P = Vendor.P;
 
 if (key == IK_P)
 {
  
  
  if (CurSelection != None)
  {
   Price = BorderlandsWeapon(CurSelection.Item).GetResaleValue();
   
   if (CurSelection.Item.Owner != P)
   {
    bBuy = True;
    CurSelection.Item.Frob(Vendor.P, None);

    if (P.Credits < Price * 5)
    {
     Vendor.PlayErrorSound();
     bReturn = True;
    }
    if (P.FindInventorySlot(CurSelection.Item, True) == False && !bReturn)
    {
     Vendor.PlayFullSound();
     bReturn = True;
    }
    
    if (P.FindInventorySlot(CurSelection.Item, True) == True && !bReturn)
    {
     CurSelection.Item.SetCollisionSize(CurSelection.Item.Default.CollisionRadius, CurSelection.Item.Default.CollisionHeight);

     CurSelection.Item.Frob(P, None);

	   CurSelection.Item.SetBase(P);

	     for( slotsRow=6; slotsRow > -1; slotsRow-- )
              for ( slotsCol=0; slotsCol < 5; slotsCol++ )
	       if (P.IsEmptyItemSlotXY(1,1,slotsCol,slotsRow) == True)
               {
		CurSelection.Item.InvPosX = slotsCol;
		CurSelection.Item.InvPosY = slotsRow;
                P.invSlots[(slotsRow * P.maxInvCols) + slotsCol] = 1;
		break;
	       }

     Vendor.PlayPurchaseSound();
  
     CurSelection.Item.PickupViewMesh = CurSelection.Item.Default.PickupViewMesh;
     CurSelection.Item.PickupViewScale = CurSelection.Item.Default.PickupViewScale;
     CurSelection.Item.DrawScale = CurSelection.Item.Default.DrawScale;
     RemoveVendorItem(CurSelection.Item);
     P.Credits -= Price * 5;
     ResetList();

     ClearHighlights();
     if (CurSelection != None) CurSelection.SetHighlight(False);
     CurSelection = None;
     StatDisplay.SetText(BuildWeaponStats());
    }
   }

   if (CurSelection.Item.Owner == P && !bBuy)
   {   
    P.Credits += Price;
    CurSelection.Item.Destroy();

    Vendor.PlayPurchaseSound();

    /*ClearHighlights();
    if (CurSelection != None) CurSelection.SetHighlight(False);
    CurSelection = None;*/

    StatDisplay.SetText("");

    ResetList();
   }
  }


 }
 return false;
}

function ProcessTransaction(Inventory I)
{
 local BorderlandsWeapon W;
 
 W = BorderlandsWeapon(i);
 
 //Vendor.BroadcastMessage(""$CurSelection$i$W);
 
 if (W.Owner != Vendor.P) AttemptPurchase(W);
 if (W.Owner == Vendor.P) AttemptResale(W);
}

function AttemptResale(BorderlandsWeapon W)
{
 local int Price;
 local DeusExPlayer P;
 
 Price = W.GetResaleValue();
 P = DeusExPlayer(GetPlayerPawn());
 
 P.Credits += Price;
 W.Destroy();
 ResetList();
}

function AttemptPurchase(BorderlandsWeapon W)
{
 local int Price;
 local DeusExPlayer P;
 local Actor A;
 local int slotsRow, slotsCol;
 
 Price = W.GetResaleValue();
 P = DeusExPlayer(GetPlayerPawn());
 
 //W.Frob(P, None);
 
 /*if (P.Credits < Price)
 {
  Vendor.PlayErrorSound();
  return;
 }
 if (P.FindInventorySlot(W, True) == False)
 {
  Vendor.PlayFullSound();
  return;
 }
 
 if (P.FindInventorySlot(W, True) == True)
 {
  W.Frob(P, None);
  
  Vendor.PlayPurchaseSound();
  
  W.PickupViewMesh = W.Default.PickupViewMesh;
  W.PickupViewScale = W.Default.PickupViewScale;
  W.DrawScale = W.Default.DrawScale;
  RemoveVendorItem(W);
  ResetList();
  P.Credits -= Price;
 }*/
}

function RemoveVendorItem(Inventory Inv)
{
 local BorderlandsWeapon W;
 local int i;
 
 W = BorderlandsWeapon(Inv);
 
 if (W != None)
 {
  for(i=0; i<10; i++)
  {
   if (Vendor.Stock[i] == W)
   {
    Vendor.Stock[i] = None;
   }
  }
 }
}

event DestroyWindow()
{
 //Vendor.CurMenu = None;
 Vendor.P = None;
 
 Super.DestroyWindow();
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}


function CreateTextWindows()
{
	//Template for new text.
	/*Text = CreateMenuHeader(15, 4, "", winClient);
	Text.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	Text.SetFont(Font'FontMenuHeaders_DS');
	Text.SetWindowAlignments(HALIGN_Left, VALIGN_Full, 4, 15);
	
	Text = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	Text.SetHeight(15);
	Text.SetPos(45, 45);
	Text.SetText("Wgt:"$HatchetPlayer(Player).CurEncumberance$"/300");*/
	
	TimerText = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	TimerText.SetHeight(20);
	TimerText.SetPos(296, 40);
	TimerText.SetFont( Font(DynamicLoadObject("DXFonts.MainMenuTrueType", Class'Font')) );

	SlotsText = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	SlotsText.SetHeight(20);
	SlotsText.SetPos(480, 368);
	SlotsText.SetFont( Font(DynamicLoadObject("DXFonts.MainMenuTrueType", Class'Font')) );
	
	WalletText = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	WalletText.SetHeight(20);
	WalletText.SetPos(45, 480);
	WalletText.SetFont( Font(DynamicLoadObject("DXFonts.MainMenuTrueType", Class'Font')) );

	TipText = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	TipText.SetHeight(20);
	TipText.SetPos(256, 480);
	TipText.SetText("|cffffffPress 'P' to Buy/Sell currently selected item.");

	StatDisplay = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	StatDisplay.SetPos(16, 368);
	StatDisplay.SetSize(240, 96);
	StatDisplay.SetFont(Font'FontMenuHeaders');

	BuyText = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	BuyText.SetHeight(20);
	BuyText.SetPos(30, 40);
	BuyText.SetFont( Font(DynamicLoadObject("DXFonts.MainMenuTrueType", Class'Font')) );
	BuyText.SetText("|p3Buy");
	SellText = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	SellText.SetHeight(20);
	SellText.SetPos(512, 40);
	SellText.SetFont( Font(DynamicLoadObject("DXFonts.MainMenuTrueType", Class'Font')) );
	SellText.SetText("|p3Sell");
}

event InitWindow()
{
 local int j;
 local class<Inventory> TempItem;
 
	Super.InitWindow();
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);

	//ResetList();
	CreateTextWindows();
}

function SelectNextItem()
{
 
 UpdateInfo();
}
function SelectPreviousItem()
{
 
 UpdateInfo();
}

function SelectNextColumn()
{
 
 UpdateInfo();
}
function SelectPreviousColumn()
{
 
 UpdateInfo();
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{

		case exitButton:
			root.PopWindow();
			bHandled = True;
			break;
		default:
			bHandled = False;
			break;
	}

	if (buttonPressed.IsA('BLVendorTile'))
	{
	 ClearHighlights();
	 
	 if (CurSelection != None) CurSelection.SetHighlight(False);
	 
	 CurSelection = BLVendorTile(buttonPressed);
	 CurSelection.SetHighlight(True);

	 StatDisplay.SetText(BuildWeaponStats());
	}

	return bHandled;
}


function ClearHighlights()
{
 local BLVendorTile T;
 
 forEach AllObjects(class'BLVendorTile', T)
 {
  T.SetHighlight(False);
 }
}

     /*clientTextures(1)=Texture'DeusExUI.UserInterface.SkillsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.SkillsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.SkillsBackground_4'
     clientTextures(4)=Texture'DeusExUI.UserInterface.SkillsBackground_5'
     clientTextures(5)=Texture'DeusExUI.UserInterface.SkillsBackground_6'

     ClientWidth=604
     ClientHeight=361*/

defaultproperties
{
     Title="Buy/Sell Weapons"
     exitButtonText="Done"
     ClientWidth=768
     ClientHeight=512

     clientTextures(0)=Texture'VendorBG1'
     clientTextures(1)=Texture'VendorBG2'
     clientTextures(2)=Texture'VendorBG3'
     clientTextures(3)=Texture'VendorBG7'
     clientTextures(4)=Texture'VendorBG8'
     clientTextures(5)=Texture'VendorBG9'
 
     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=3
     
     BackgroundStyle=DSTY_Masked
}
